/*
 * This declarations of the PIC16F916 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:30:16 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F916_H__
#define __PIC16F916_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF_ADDR               0x0000
#define TMR0_ADDR               0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR_ADDR                0x0004
#define PORTA_ADDR              0x0005
#define PORTB_ADDR              0x0006
#define PORTC_ADDR              0x0007
#define PORTE_ADDR              0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PIR1_ADDR               0x000C
#define PIR2_ADDR               0x000D
#define TMR1_ADDR               0x000E
#define TMR1L_ADDR              0x000E
#define TMR1H_ADDR              0x000F
#define T1CON_ADDR              0x0010
#define TMR2_ADDR               0x0011
#define T2CON_ADDR              0x0012
#define SSPBUF_ADDR             0x0013
#define SSPCON_ADDR             0x0014
#define CCPR1_ADDR              0x0015
#define CCPR1L_ADDR             0x0015
#define CCPR1H_ADDR             0x0016
#define CCP1CON_ADDR            0x0017
#define RCSTA_ADDR              0x0018
#define TXREG_ADDR              0x0019
#define RCREG_ADDR              0x001A
#define ADRESH_ADDR             0x001E
#define ADCON0_ADDR             0x001F
#define OPTION_REG_ADDR         0x0081
#define TRISA_ADDR              0x0085
#define TRISB_ADDR              0x0086
#define TRISC_ADDR              0x0087
#define TRISE_ADDR              0x0089
#define PIE1_ADDR               0x008C
#define PIE2_ADDR               0x008D
#define PCON_ADDR               0x008E
#define OSCCON_ADDR             0x008F
#define OSCTUNE_ADDR            0x0090
#define ANSEL_ADDR              0x0091
#define PR2_ADDR                0x0092
#define SSPADD_ADDR             0x0093
#define SSPSTAT_ADDR            0x0094
#define WPU_ADDR                0x0095
#define WPUB_ADDR               0x0095
#define IOC_ADDR                0x0096
#define IOCB_ADDR               0x0096
#define CMCON1_ADDR             0x0097
#define TXSTA_ADDR              0x0098
#define SPBRG_ADDR              0x0099
#define CMCON0_ADDR             0x009C
#define VRCON_ADDR              0x009D
#define ADRESL_ADDR             0x009E
#define ADCON1_ADDR             0x009F
#define WDTCON_ADDR             0x0105
#define LCDCON_ADDR             0x0107
#define LCDPS_ADDR              0x0108
#define LVDCON_ADDR             0x0109
#define EEDATA_ADDR             0x010C
#define EEDATL_ADDR             0x010C
#define EEADR_ADDR              0x010D
#define EEADRL_ADDR             0x010D
#define EEDATH_ADDR             0x010E
#define EEADRH_ADDR             0x010F
#define LCDDATA0_ADDR           0x0110
#define LCDDATA1_ADDR           0x0111
#define LCDDATA3_ADDR           0x0113
#define LCDDATA4_ADDR           0x0114
#define LCDDATA6_ADDR           0x0116
#define LCDDATA7_ADDR           0x0117
#define LCDDATA9_ADDR           0x0119
#define LCDDATA10_ADDR          0x011A
#define LCDSE0_ADDR             0x011C
#define LCDSE1_ADDR             0x011D
#define EECON1_ADDR             0x018C
#define EECON2_ADDR             0x018D

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF;
extern __at(0x0001) __sfr TMR0;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef union
  {
  struct
    {
    unsigned C                  : 1;
    unsigned DC                 : 1;
    unsigned Z                  : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned RP0                : 1;
    unsigned RP1                : 1;
    unsigned IRP                : 1;
    };

  struct
    {
    unsigned                    : 5;
    unsigned RP                 : 2;
    unsigned                    : 1;
    };
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10
#define _RP0                    0x20
#define _RP1                    0x40
#define _IRP                    0x80

//==============================================================================

extern __at(0x0004) __sfr FSR;

//==============================================================================
//        PORTA Bits

extern __at(0x0005) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x0005) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0006) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x0006) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0007) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x0007) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0009) __sfr PORTE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RE3                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTEbits_t;

extern __at(0x0009) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08

//==============================================================================

extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x000C) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned EEIF                 : 1;
  } __PIR1bits_t;

extern __at(0x000C) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _EEIF                   0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x000D) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LVDIF                : 1;
  unsigned                      : 1;
  unsigned LCDIF                : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x000D) volatile __PIR2bits_t PIR2bits;

#define _LVDIF                  0x04
#define _LCDIF                  0x10
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================

extern __at(0x000E) __sfr TMR1;
extern __at(0x000E) __sfr TMR1L;
extern __at(0x000F) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0010) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1GE             : 1;
    unsigned T1GINV             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GE               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0010) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1INSYNC               0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1GE                 0x40
#define _T1GE                   0x40
#define _T1GINV                 0x80

//==============================================================================

extern __at(0x0011) __sfr TMR2;

//==============================================================================
//        T2CON Bits

extern __at(0x0012) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned TOUTPS0            : 1;
    unsigned TOUTPS1            : 1;
    unsigned TOUTPS2            : 1;
    unsigned TOUTPS3            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned TOUTPS             : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0012) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _TOUTPS0                0x08
#define _TOUTPS1                0x10
#define _TOUTPS2                0x20
#define _TOUTPS3                0x40

//==============================================================================

extern __at(0x0013) __sfr SSPBUF;

//==============================================================================
//        SSPCON Bits

extern __at(0x0014) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0014) volatile __SSPCONbits_t SSPCONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================

extern __at(0x0015) __sfr CCPR1;
extern __at(0x0015) __sfr CCPR1L;
extern __at(0x0016) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0017) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };
  } __CCP1CONbits_t;

extern __at(0x0017) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _CCP1Y                  0x10
#define _CCP1X                  0x20

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0018) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC9                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0018) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _SPEN                   0x80

//==============================================================================

extern __at(0x0019) __sfr TXREG;
extern __at(0x001A) __sfr RCREG;
extern __at(0x001E) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x001F) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 3;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 5;
    unsigned VCFG               : 2;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x001F) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _NOT_DONE               0x02
#define _GO_DONE                0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _VCFG0                  0x20
#define _VCFG1                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0081) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0081) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_RBPU               0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0085) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x0085) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0086) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x0086) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0087) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x0087) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0089) __sfr TRISE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRISE3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __TRISEbits_t;

extern __at(0x0089) volatile __TRISEbits_t TRISEbits;

#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x008C) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned EEIE                 : 1;
  } __PIE1bits_t;

extern __at(0x008C) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _EEIE                   0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x008D) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LVDIE                : 1;
  unsigned                      : 1;
  unsigned LCDIE                : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x008D) volatile __PIE2bits_t PIE2bits;

#define _LVDIE                  0x04
#define _LCDIE                  0x10
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x008E) __sfr PCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_BO             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PCONbits_t;

extern __at(0x008E) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_BO                 0x01
#define _NOT_POR                0x02
#define _SBOREN                 0x10

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x008F) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS                : 1;
    unsigned LTS                : 1;
    unsigned HTS                : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x008F) volatile __OSCCONbits_t OSCCONbits;

#define _SCS                    0x01
#define _LTS                    0x02
#define _HTS                    0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0090) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0090) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x0091) __sfr ANSEL;

typedef union
  {
  struct
    {
    unsigned ANS0               : 1;
    unsigned ANS1               : 1;
    unsigned ANS2               : 1;
    unsigned ANS3               : 1;
    unsigned ANS4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned AN4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AN                 : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned ANS                : 5;
    unsigned                    : 3;
    };
  } __ANSELbits_t;

extern __at(0x0091) volatile __ANSELbits_t ANSELbits;

#define _ANS0                   0x01
#define _AN0                    0x01
#define _ANS1                   0x02
#define _AN1                    0x02
#define _ANS2                   0x04
#define _AN2                    0x04
#define _ANS3                   0x08
#define _AN3                    0x08
#define _ANS4                   0x10
#define _AN4                    0x10

//==============================================================================

extern __at(0x0092) __sfr PR2;
extern __at(0x0093) __sfr SSPADD;

//==============================================================================
//        SSPSTAT Bits

extern __at(0x0094) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DATA           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0094) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _I2C_READ               0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _R_W                    0x04
#define _READ_WRITE             0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _I2C_DATA               0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _D_A                    0x20
#define _DATA_ADDRESS           0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        WPU Bits

extern __at(0x0095) __sfr WPU;

typedef union
  {
  struct
    {
    unsigned WPUB0              : 1;
    unsigned WPUB1              : 1;
    unsigned WPUB2              : 1;
    unsigned WPUB3              : 1;
    unsigned WPUB4              : 1;
    unsigned WPUB5              : 1;
    unsigned WPUB6              : 1;
    unsigned WPUB7              : 1;
    };

  struct
    {
    unsigned WPU0               : 1;
    unsigned WPU1               : 1;
    unsigned WPU2               : 1;
    unsigned WPU3               : 1;
    unsigned WPU4               : 1;
    unsigned WPU5               : 1;
    unsigned WPU6               : 1;
    unsigned WPU7               : 1;
    };
  } __WPUbits_t;

extern __at(0x0095) volatile __WPUbits_t WPUbits;

#define _WPUB0                  0x01
#define _WPU0                   0x01
#define _WPUB1                  0x02
#define _WPU1                   0x02
#define _WPUB2                  0x04
#define _WPU2                   0x04
#define _WPUB3                  0x08
#define _WPU3                   0x08
#define _WPUB4                  0x10
#define _WPU4                   0x10
#define _WPUB5                  0x20
#define _WPU5                   0x20
#define _WPUB6                  0x40
#define _WPU6                   0x40
#define _WPUB7                  0x80
#define _WPU7                   0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0095) __sfr WPUB;

typedef union
  {
  struct
    {
    unsigned WPUB0              : 1;
    unsigned WPUB1              : 1;
    unsigned WPUB2              : 1;
    unsigned WPUB3              : 1;
    unsigned WPUB4              : 1;
    unsigned WPUB5              : 1;
    unsigned WPUB6              : 1;
    unsigned WPUB7              : 1;
    };

  struct
    {
    unsigned WPU0               : 1;
    unsigned WPU1               : 1;
    unsigned WPU2               : 1;
    unsigned WPU3               : 1;
    unsigned WPU4               : 1;
    unsigned WPU5               : 1;
    unsigned WPU6               : 1;
    unsigned WPU7               : 1;
    };
  } __WPUBbits_t;

extern __at(0x0095) volatile __WPUBbits_t WPUBbits;

#define _WPUB_WPUB0             0x01
#define _WPUB_WPU0              0x01
#define _WPUB_WPUB1             0x02
#define _WPUB_WPU1              0x02
#define _WPUB_WPUB2             0x04
#define _WPUB_WPU2              0x04
#define _WPUB_WPUB3             0x08
#define _WPUB_WPU3              0x08
#define _WPUB_WPUB4             0x10
#define _WPUB_WPU4              0x10
#define _WPUB_WPUB5             0x20
#define _WPUB_WPU5              0x20
#define _WPUB_WPUB6             0x40
#define _WPUB_WPU6              0x40
#define _WPUB_WPUB7             0x80
#define _WPUB_WPU7              0x80

//==============================================================================


//==============================================================================
//        IOC Bits

extern __at(0x0096) __sfr IOC;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IOCB4              : 1;
    unsigned IOCB5              : 1;
    unsigned IOCB6              : 1;
    unsigned IOCB7              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IOC4               : 1;
    unsigned IOC5               : 1;
    unsigned IOC6               : 1;
    unsigned IOC7               : 1;
    };
  } __IOCbits_t;

extern __at(0x0096) volatile __IOCbits_t IOCbits;

#define _IOCB4                  0x10
#define _IOC4                   0x10
#define _IOCB5                  0x20
#define _IOC5                   0x20
#define _IOCB6                  0x40
#define _IOC6                   0x40
#define _IOCB7                  0x80
#define _IOC7                   0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0096) __sfr IOCB;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IOCB4              : 1;
    unsigned IOCB5              : 1;
    unsigned IOCB6              : 1;
    unsigned IOCB7              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IOC4               : 1;
    unsigned IOC5               : 1;
    unsigned IOC6               : 1;
    unsigned IOC7               : 1;
    };
  } __IOCBbits_t;

extern __at(0x0096) volatile __IOCBbits_t IOCBbits;

#define _IOCB_IOCB4             0x10
#define _IOCB_IOC4              0x10
#define _IOCB_IOCB5             0x20
#define _IOCB_IOC5              0x20
#define _IOCB_IOCB6             0x40
#define _IOCB_IOC6              0x40
#define _IOCB_IOCB7             0x80
#define _IOCB_IOC7              0x80

//==============================================================================


//==============================================================================
//        CMCON1 Bits

extern __at(0x0097) __sfr CMCON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned T1GSS                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMCON1bits_t;

extern __at(0x0097) volatile __CMCON1bits_t CMCON1bits;

#define _C2SYNC                 0x01
#define _T1GSS                  0x02

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0098) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned                    : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX8_9              : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0098) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _NOT_TX8                0x40
#define _TX8_9                  0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0099) __sfr SPBRG;

//==============================================================================
//        CMCON0 Bits

extern __at(0x009C) __sfr CMCON0;

typedef union
  {
  struct
    {
    unsigned CM0                : 1;
    unsigned CM1                : 1;
    unsigned CM2                : 1;
    unsigned CIS                : 1;
    unsigned C1INV              : 1;
    unsigned C2INV              : 1;
    unsigned C1OUT              : 1;
    unsigned C2OUT              : 1;
    };

  struct
    {
    unsigned CM                 : 3;
    unsigned                    : 5;
    };
  } __CMCON0bits_t;

extern __at(0x009C) volatile __CMCON0bits_t CMCON0bits;

#define _CM0                    0x01
#define _CM1                    0x02
#define _CM2                    0x04
#define _CIS                    0x08
#define _C1INV                  0x10
#define _C2INV                  0x20
#define _C1OUT                  0x40
#define _C2OUT                  0x80

//==============================================================================


//==============================================================================
//        VRCON Bits

extern __at(0x009D) __sfr VRCON;

typedef union
  {
  struct
    {
    unsigned VR0                : 1;
    unsigned VR1                : 1;
    unsigned VR2                : 1;
    unsigned VR3                : 1;
    unsigned                    : 1;
    unsigned VRR                : 1;
    unsigned                    : 1;
    unsigned VREN               : 1;
    };

  struct
    {
    unsigned VR                 : 4;
    unsigned                    : 4;
    };
  } __VRCONbits_t;

extern __at(0x009D) volatile __VRCONbits_t VRCONbits;

#define _VR0                    0x01
#define _VR1                    0x02
#define _VR2                    0x04
#define _VR3                    0x08
#define _VRR                    0x20
#define _VREN                   0x80

//==============================================================================

extern __at(0x009E) __sfr ADRESL;

//==============================================================================
//        ADCON1 Bits

extern __at(0x009F) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009F) volatile __ADCON1bits_t ADCON1bits;

#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0105) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 4;
    unsigned                    : 3;
    };
  } __WDTCONbits_t;

extern __at(0x0105) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10

//==============================================================================


//==============================================================================
//        LCDCON Bits

extern __at(0x0107) __sfr LCDCON;

typedef union
  {
  struct
    {
    unsigned LMUX0              : 1;
    unsigned LMUX1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned VLCDEN             : 1;
    unsigned WERR               : 1;
    unsigned SLPEN              : 1;
    unsigned LCDEN              : 1;
    };

  struct
    {
    unsigned LMUX               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CS                 : 2;
    unsigned                    : 4;
    };
  } __LCDCONbits_t;

extern __at(0x0107) volatile __LCDCONbits_t LCDCONbits;

#define _LMUX0                  0x01
#define _LMUX1                  0x02
#define _CS0                    0x04
#define _CS1                    0x08
#define _VLCDEN                 0x10
#define _WERR                   0x20
#define _SLPEN                  0x40
#define _LCDEN                  0x80

//==============================================================================


//==============================================================================
//        LCDPS Bits

extern __at(0x0108) __sfr LCDPS;

typedef union
  {
  struct
    {
    unsigned LP0                : 1;
    unsigned LP1                : 1;
    unsigned LP2                : 1;
    unsigned LP3                : 1;
    unsigned WA                 : 1;
    unsigned LCDA               : 1;
    unsigned BIASMD             : 1;
    unsigned WFT                : 1;
    };

  struct
    {
    unsigned LP                 : 4;
    unsigned                    : 4;
    };
  } __LCDPSbits_t;

extern __at(0x0108) volatile __LCDPSbits_t LCDPSbits;

#define _LP0                    0x01
#define _LP1                    0x02
#define _LP2                    0x04
#define _LP3                    0x08
#define _WA                     0x10
#define _LCDA                   0x20
#define _BIASMD                 0x40
#define _WFT                    0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0109) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned                    : 1;
    unsigned LVDEN              : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL               : 3;
    unsigned                    : 5;
    };
  } __LVDCONbits_t;

extern __at(0x0109) volatile __LVDCONbits_t LVDCONbits;

#define _LVDL0                  0x01
#define _LVDL1                  0x02
#define _LVDL2                  0x04
#define _LVDEN                  0x10
#define _IRVST                  0x20

//==============================================================================


//==============================================================================
//        EEDATA Bits

extern __at(0x010C) __sfr EEDATA;

typedef struct
  {
  unsigned EEDATL0              : 1;
  unsigned EEDATL1              : 1;
  unsigned EEDATL2              : 1;
  unsigned EEDATL3              : 1;
  unsigned EEDATL4              : 1;
  unsigned EEDATL5              : 1;
  unsigned EEDATL6              : 1;
  unsigned EEDATL7              : 1;
  } __EEDATAbits_t;

extern __at(0x010C) volatile __EEDATAbits_t EEDATAbits;

#define _EEDATL0                0x01
#define _EEDATL1                0x02
#define _EEDATL2                0x04
#define _EEDATL3                0x08
#define _EEDATL4                0x10
#define _EEDATL5                0x20
#define _EEDATL6                0x40
#define _EEDATL7                0x80

//==============================================================================


//==============================================================================
//        EEDATL Bits

extern __at(0x010C) __sfr EEDATL;

typedef struct
  {
  unsigned EEDATL0              : 1;
  unsigned EEDATL1              : 1;
  unsigned EEDATL2              : 1;
  unsigned EEDATL3              : 1;
  unsigned EEDATL4              : 1;
  unsigned EEDATL5              : 1;
  unsigned EEDATL6              : 1;
  unsigned EEDATL7              : 1;
  } __EEDATLbits_t;

extern __at(0x010C) volatile __EEDATLbits_t EEDATLbits;

#define _EEDATL_EEDATL0         0x01
#define _EEDATL_EEDATL1         0x02
#define _EEDATL_EEDATL2         0x04
#define _EEDATL_EEDATL3         0x08
#define _EEDATL_EEDATL4         0x10
#define _EEDATL_EEDATL5         0x20
#define _EEDATL_EEDATL6         0x40
#define _EEDATL_EEDATL7         0x80

//==============================================================================


//==============================================================================
//        EEADR Bits

extern __at(0x010D) __sfr EEADR;

typedef struct
  {
  unsigned EEADRL0              : 1;
  unsigned EEADRL1              : 1;
  unsigned EEADRL2              : 1;
  unsigned EEADRL3              : 1;
  unsigned EEADRL4              : 1;
  unsigned EEADRL5              : 1;
  unsigned EEADRL6              : 1;
  unsigned EEADRL7              : 1;
  } __EEADRbits_t;

extern __at(0x010D) volatile __EEADRbits_t EEADRbits;

#define _EEADRL0                0x01
#define _EEADRL1                0x02
#define _EEADRL2                0x04
#define _EEADRL3                0x08
#define _EEADRL4                0x10
#define _EEADRL5                0x20
#define _EEADRL6                0x40
#define _EEADRL7                0x80

//==============================================================================


//==============================================================================
//        EEADRL Bits

extern __at(0x010D) __sfr EEADRL;

typedef struct
  {
  unsigned EEADRL0              : 1;
  unsigned EEADRL1              : 1;
  unsigned EEADRL2              : 1;
  unsigned EEADRL3              : 1;
  unsigned EEADRL4              : 1;
  unsigned EEADRL5              : 1;
  unsigned EEADRL6              : 1;
  unsigned EEADRL7              : 1;
  } __EEADRLbits_t;

extern __at(0x010D) volatile __EEADRLbits_t EEADRLbits;

#define _EEADRL_EEADRL0         0x01
#define _EEADRL_EEADRL1         0x02
#define _EEADRL_EEADRL2         0x04
#define _EEADRL_EEADRL3         0x08
#define _EEADRL_EEADRL4         0x10
#define _EEADRL_EEADRL5         0x20
#define _EEADRL_EEADRL6         0x40
#define _EEADRL_EEADRL7         0x80

//==============================================================================


//==============================================================================
//        EEDATH Bits

extern __at(0x010E) __sfr EEDATH;

typedef union
  {
  struct
    {
    unsigned EEDATH0            : 1;
    unsigned EEDATH1            : 1;
    unsigned EEDATH2            : 1;
    unsigned EEDATH3            : 1;
    unsigned EEDATH4            : 1;
    unsigned EEDATH5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EEDATH             : 6;
    unsigned                    : 2;
    };
  } __EEDATHbits_t;

extern __at(0x010E) volatile __EEDATHbits_t EEDATHbits;

#define _EEDATH0                0x01
#define _EEDATH1                0x02
#define _EEDATH2                0x04
#define _EEDATH3                0x08
#define _EEDATH4                0x10
#define _EEDATH5                0x20

//==============================================================================


//==============================================================================
//        EEADRH Bits

extern __at(0x010F) __sfr EEADRH;

typedef union
  {
  struct
    {
    unsigned EEADRH0            : 1;
    unsigned EEADRH1            : 1;
    unsigned EEADRH2            : 1;
    unsigned EEADRH3            : 1;
    unsigned EEADRH4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned EEADRH             : 5;
    unsigned                    : 3;
    };
  } __EEADRHbits_t;

extern __at(0x010F) volatile __EEADRHbits_t EEADRHbits;

#define _EEADRH0                0x01
#define _EEADRH1                0x02
#define _EEADRH2                0x04
#define _EEADRH3                0x08
#define _EEADRH4                0x10

//==============================================================================


//==============================================================================
//        LCDDATA0 Bits

extern __at(0x0110) __sfr LCDDATA0;

typedef union
  {
  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };

  struct
    {
    unsigned SEG0COM0           : 1;
    unsigned SEG1COM0           : 1;
    unsigned SEG2COM0           : 1;
    unsigned SEG3COM0           : 1;
    unsigned SEG4COM0           : 1;
    unsigned SEG5COM0           : 1;
    unsigned SEG6COM0           : 1;
    unsigned SEG7COM0           : 1;
    };

  struct
    {
    unsigned S0C0               : 1;
    unsigned S1C0               : 1;
    unsigned S2C0               : 1;
    unsigned S3C0               : 1;
    unsigned S4C0               : 1;
    unsigned S5C0               : 1;
    unsigned S6C0               : 1;
    unsigned S7C0               : 1;
    };
  } __LCDDATA0bits_t;

extern __at(0x0110) volatile __LCDDATA0bits_t LCDDATA0bits;

#define _SEG0                   0x01
#define _SEG0COM0               0x01
#define _S0C0                   0x01
#define _SEG1                   0x02
#define _SEG1COM0               0x02
#define _S1C0                   0x02
#define _SEG2                   0x04
#define _SEG2COM0               0x04
#define _S2C0                   0x04
#define _SEG3                   0x08
#define _SEG3COM0               0x08
#define _S3C0                   0x08
#define _SEG4                   0x10
#define _SEG4COM0               0x10
#define _S4C0                   0x10
#define _SEG5                   0x20
#define _SEG5COM0               0x20
#define _S5C0                   0x20
#define _SEG6                   0x40
#define _SEG6COM0               0x40
#define _S6C0                   0x40
#define _SEG7                   0x80
#define _SEG7COM0               0x80
#define _S7C0                   0x80

//==============================================================================


//==============================================================================
//        LCDDATA1 Bits

extern __at(0x0111) __sfr LCDDATA1;

typedef union
  {
  struct
    {
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned SEG12              : 1;
    unsigned SEG13              : 1;
    unsigned SEG14              : 1;
    unsigned SEG15              : 1;
    };

  struct
    {
    unsigned SEG8COM0           : 1;
    unsigned SEG9COM0           : 1;
    unsigned SEG10COM0          : 1;
    unsigned SEG11COM0          : 1;
    unsigned SEG12COM0          : 1;
    unsigned SEG13COM0          : 1;
    unsigned SEG14COM0          : 1;
    unsigned SEG15COM0          : 1;
    };

  struct
    {
    unsigned S8C0               : 1;
    unsigned S9C0               : 1;
    unsigned S10C0              : 1;
    unsigned S11C0              : 1;
    unsigned S12C0              : 1;
    unsigned S13C0              : 1;
    unsigned S14C0              : 1;
    unsigned S15C0              : 1;
    };
  } __LCDDATA1bits_t;

extern __at(0x0111) volatile __LCDDATA1bits_t LCDDATA1bits;

#define _SEG8                   0x01
#define _SEG8COM0               0x01
#define _S8C0                   0x01
#define _SEG9                   0x02
#define _SEG9COM0               0x02
#define _S9C0                   0x02
#define _SEG10                  0x04
#define _SEG10COM0              0x04
#define _S10C0                  0x04
#define _SEG11                  0x08
#define _SEG11COM0              0x08
#define _S11C0                  0x08
#define _SEG12                  0x10
#define _SEG12COM0              0x10
#define _S12C0                  0x10
#define _SEG13                  0x20
#define _SEG13COM0              0x20
#define _S13C0                  0x20
#define _SEG14                  0x40
#define _SEG14COM0              0x40
#define _S14C0                  0x40
#define _SEG15                  0x80
#define _SEG15COM0              0x80
#define _S15C0                  0x80

//==============================================================================


//==============================================================================
//        LCDDATA3 Bits

extern __at(0x0113) __sfr LCDDATA3;

typedef union
  {
  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };

  struct
    {
    unsigned SEG0COM1           : 1;
    unsigned SEG1COM1           : 1;
    unsigned SEG2COM1           : 1;
    unsigned SEG3COM1           : 1;
    unsigned SEG4COM1           : 1;
    unsigned SEG5COM1           : 1;
    unsigned SEG6COM1           : 1;
    unsigned SEG7COM1           : 1;
    };

  struct
    {
    unsigned S0C1               : 1;
    unsigned S1C1               : 1;
    unsigned S2C1               : 1;
    unsigned S3C1               : 1;
    unsigned S4C1               : 1;
    unsigned S5C1               : 1;
    unsigned S6C1               : 1;
    unsigned S7C1               : 1;
    };
  } __LCDDATA3bits_t;

extern __at(0x0113) volatile __LCDDATA3bits_t LCDDATA3bits;

#define _LCDDATA3_SEG0          0x01
#define _LCDDATA3_SEG0COM1      0x01
#define _LCDDATA3_S0C1          0x01
#define _LCDDATA3_SEG1          0x02
#define _LCDDATA3_SEG1COM1      0x02
#define _LCDDATA3_S1C1          0x02
#define _LCDDATA3_SEG2          0x04
#define _LCDDATA3_SEG2COM1      0x04
#define _LCDDATA3_S2C1          0x04
#define _LCDDATA3_SEG3          0x08
#define _LCDDATA3_SEG3COM1      0x08
#define _LCDDATA3_S3C1          0x08
#define _LCDDATA3_SEG4          0x10
#define _LCDDATA3_SEG4COM1      0x10
#define _LCDDATA3_S4C1          0x10
#define _LCDDATA3_SEG5          0x20
#define _LCDDATA3_SEG5COM1      0x20
#define _LCDDATA3_S5C1          0x20
#define _LCDDATA3_SEG6          0x40
#define _LCDDATA3_SEG6COM1      0x40
#define _LCDDATA3_S6C1          0x40
#define _LCDDATA3_SEG7          0x80
#define _LCDDATA3_SEG7COM1      0x80
#define _LCDDATA3_S7C1          0x80

//==============================================================================


//==============================================================================
//        LCDDATA4 Bits

extern __at(0x0114) __sfr LCDDATA4;

typedef union
  {
  struct
    {
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned SEG12              : 1;
    unsigned SEG13              : 1;
    unsigned SEG14              : 1;
    unsigned SEG15              : 1;
    };

  struct
    {
    unsigned SEG8COM1           : 1;
    unsigned SEG9COM1           : 1;
    unsigned SEG10COM1          : 1;
    unsigned SEG11COM1          : 1;
    unsigned SEG12COM1          : 1;
    unsigned SEG13COM1          : 1;
    unsigned SEG14COM1          : 1;
    unsigned SEG15COM1          : 1;
    };

  struct
    {
    unsigned S8C1               : 1;
    unsigned S9C1               : 1;
    unsigned S10C1              : 1;
    unsigned S11C1              : 1;
    unsigned S12C1              : 1;
    unsigned S13C1              : 1;
    unsigned S14C1              : 1;
    unsigned S15C1              : 1;
    };
  } __LCDDATA4bits_t;

extern __at(0x0114) volatile __LCDDATA4bits_t LCDDATA4bits;

#define _LCDDATA4_SEG8          0x01
#define _LCDDATA4_SEG8COM1      0x01
#define _LCDDATA4_S8C1          0x01
#define _LCDDATA4_SEG9          0x02
#define _LCDDATA4_SEG9COM1      0x02
#define _LCDDATA4_S9C1          0x02
#define _LCDDATA4_SEG10         0x04
#define _LCDDATA4_SEG10COM1     0x04
#define _LCDDATA4_S10C1         0x04
#define _LCDDATA4_SEG11         0x08
#define _LCDDATA4_SEG11COM1     0x08
#define _LCDDATA4_S11C1         0x08
#define _LCDDATA4_SEG12         0x10
#define _LCDDATA4_SEG12COM1     0x10
#define _LCDDATA4_S12C1         0x10
#define _LCDDATA4_SEG13         0x20
#define _LCDDATA4_SEG13COM1     0x20
#define _LCDDATA4_S13C1         0x20
#define _LCDDATA4_SEG14         0x40
#define _LCDDATA4_SEG14COM1     0x40
#define _LCDDATA4_S14C1         0x40
#define _LCDDATA4_SEG15         0x80
#define _LCDDATA4_SEG15COM1     0x80
#define _LCDDATA4_S15C1         0x80

//==============================================================================


//==============================================================================
//        LCDDATA6 Bits

extern __at(0x0116) __sfr LCDDATA6;

typedef union
  {
  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };

  struct
    {
    unsigned SEG0COM2           : 1;
    unsigned SEG1COM2           : 1;
    unsigned SEG2COM2           : 1;
    unsigned SEG3COM2           : 1;
    unsigned SEG4COM2           : 1;
    unsigned SEG5COM2           : 1;
    unsigned SEG6COM2           : 1;
    unsigned SEG7COM2           : 1;
    };

  struct
    {
    unsigned S0C2               : 1;
    unsigned S1C2               : 1;
    unsigned S2C2               : 1;
    unsigned S3C2               : 1;
    unsigned S4C2               : 1;
    unsigned S5C2               : 1;
    unsigned S6C2               : 1;
    unsigned S7C2               : 1;
    };
  } __LCDDATA6bits_t;

extern __at(0x0116) volatile __LCDDATA6bits_t LCDDATA6bits;

#define _LCDDATA6_SEG0          0x01
#define _LCDDATA6_SEG0COM2      0x01
#define _LCDDATA6_S0C2          0x01
#define _LCDDATA6_SEG1          0x02
#define _LCDDATA6_SEG1COM2      0x02
#define _LCDDATA6_S1C2          0x02
#define _LCDDATA6_SEG2          0x04
#define _LCDDATA6_SEG2COM2      0x04
#define _LCDDATA6_S2C2          0x04
#define _LCDDATA6_SEG3          0x08
#define _LCDDATA6_SEG3COM2      0x08
#define _LCDDATA6_S3C2          0x08
#define _LCDDATA6_SEG4          0x10
#define _LCDDATA6_SEG4COM2      0x10
#define _LCDDATA6_S4C2          0x10
#define _LCDDATA6_SEG5          0x20
#define _LCDDATA6_SEG5COM2      0x20
#define _LCDDATA6_S5C2          0x20
#define _LCDDATA6_SEG6          0x40
#define _LCDDATA6_SEG6COM2      0x40
#define _LCDDATA6_S6C2          0x40
#define _LCDDATA6_SEG7          0x80
#define _LCDDATA6_SEG7COM2      0x80
#define _LCDDATA6_S7C2          0x80

//==============================================================================


//==============================================================================
//        LCDDATA7 Bits

extern __at(0x0117) __sfr LCDDATA7;

typedef union
  {
  struct
    {
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned SEG12              : 1;
    unsigned SEG13              : 1;
    unsigned SEG14              : 1;
    unsigned SEG15              : 1;
    };

  struct
    {
    unsigned SEG8COM2           : 1;
    unsigned SEG9COM2           : 1;
    unsigned SEG10COM2          : 1;
    unsigned SEG11COM2          : 1;
    unsigned SEG12COM2          : 1;
    unsigned SEG13COM2          : 1;
    unsigned SEG14COM2          : 1;
    unsigned SEG15COM2          : 1;
    };

  struct
    {
    unsigned S8C2               : 1;
    unsigned S9C2               : 1;
    unsigned S10C2              : 1;
    unsigned S11C2              : 1;
    unsigned S12C2              : 1;
    unsigned S13C2              : 1;
    unsigned S14C2              : 1;
    unsigned S15C2              : 1;
    };
  } __LCDDATA7bits_t;

extern __at(0x0117) volatile __LCDDATA7bits_t LCDDATA7bits;

#define _LCDDATA7_SEG8          0x01
#define _LCDDATA7_SEG8COM2      0x01
#define _LCDDATA7_S8C2          0x01
#define _LCDDATA7_SEG9          0x02
#define _LCDDATA7_SEG9COM2      0x02
#define _LCDDATA7_S9C2          0x02
#define _LCDDATA7_SEG10         0x04
#define _LCDDATA7_SEG10COM2     0x04
#define _LCDDATA7_S10C2         0x04
#define _LCDDATA7_SEG11         0x08
#define _LCDDATA7_SEG11COM2     0x08
#define _LCDDATA7_S11C2         0x08
#define _LCDDATA7_SEG12         0x10
#define _LCDDATA7_SEG12COM2     0x10
#define _LCDDATA7_S12C2         0x10
#define _LCDDATA7_SEG13         0x20
#define _LCDDATA7_SEG13COM2     0x20
#define _LCDDATA7_S13C2         0x20
#define _LCDDATA7_SEG14         0x40
#define _LCDDATA7_SEG14COM2     0x40
#define _LCDDATA7_S14C2         0x40
#define _LCDDATA7_SEG15         0x80
#define _LCDDATA7_SEG15COM2     0x80
#define _LCDDATA7_S15C2         0x80

//==============================================================================


//==============================================================================
//        LCDDATA9 Bits

extern __at(0x0119) __sfr LCDDATA9;

typedef union
  {
  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };

  struct
    {
    unsigned SEG0COM3           : 1;
    unsigned SEG1COM3           : 1;
    unsigned SEG2COM3           : 1;
    unsigned SEG3COM3           : 1;
    unsigned SEG4COM3           : 1;
    unsigned SEG5COM3           : 1;
    unsigned SEG6COM3           : 1;
    unsigned SEG7COM3           : 1;
    };

  struct
    {
    unsigned S0C3               : 1;
    unsigned S1C3               : 1;
    unsigned S2C3               : 1;
    unsigned S3C3               : 1;
    unsigned S4C3               : 1;
    unsigned S5C3               : 1;
    unsigned S6C3               : 1;
    unsigned S7C3               : 1;
    };
  } __LCDDATA9bits_t;

extern __at(0x0119) volatile __LCDDATA9bits_t LCDDATA9bits;

#define _LCDDATA9_SEG0          0x01
#define _LCDDATA9_SEG0COM3      0x01
#define _LCDDATA9_S0C3          0x01
#define _LCDDATA9_SEG1          0x02
#define _LCDDATA9_SEG1COM3      0x02
#define _LCDDATA9_S1C3          0x02
#define _LCDDATA9_SEG2          0x04
#define _LCDDATA9_SEG2COM3      0x04
#define _LCDDATA9_S2C3          0x04
#define _LCDDATA9_SEG3          0x08
#define _LCDDATA9_SEG3COM3      0x08
#define _LCDDATA9_S3C3          0x08
#define _LCDDATA9_SEG4          0x10
#define _LCDDATA9_SEG4COM3      0x10
#define _LCDDATA9_S4C3          0x10
#define _LCDDATA9_SEG5          0x20
#define _LCDDATA9_SEG5COM3      0x20
#define _LCDDATA9_S5C3          0x20
#define _LCDDATA9_SEG6          0x40
#define _LCDDATA9_SEG6COM3      0x40
#define _LCDDATA9_S6C3          0x40
#define _LCDDATA9_SEG7          0x80
#define _LCDDATA9_SEG7COM3      0x80
#define _LCDDATA9_S7C3          0x80

//==============================================================================


//==============================================================================
//        LCDDATA10 Bits

extern __at(0x011A) __sfr LCDDATA10;

typedef union
  {
  struct
    {
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned SEG12              : 1;
    unsigned SEG13              : 1;
    unsigned SEG14              : 1;
    unsigned SEG15              : 1;
    };

  struct
    {
    unsigned SEG8COM3           : 1;
    unsigned SEG9COM3           : 1;
    unsigned SEG10COM3          : 1;
    unsigned SEG11COM3          : 1;
    unsigned SEG12COM3          : 1;
    unsigned SEG13COM3          : 1;
    unsigned SEG14COM3          : 1;
    unsigned SEG15COM3          : 1;
    };

  struct
    {
    unsigned S8C3               : 1;
    unsigned S9C3               : 1;
    unsigned S10C3              : 1;
    unsigned S11C3              : 1;
    unsigned S12C3              : 1;
    unsigned S13C3              : 1;
    unsigned S14C3              : 1;
    unsigned S15C3              : 1;
    };
  } __LCDDATA10bits_t;

extern __at(0x011A) volatile __LCDDATA10bits_t LCDDATA10bits;

#define _LCDDATA10_SEG8         0x01
#define _LCDDATA10_SEG8COM3     0x01
#define _LCDDATA10_S8C3         0x01
#define _LCDDATA10_SEG9         0x02
#define _LCDDATA10_SEG9COM3     0x02
#define _LCDDATA10_S9C3         0x02
#define _LCDDATA10_SEG10        0x04
#define _LCDDATA10_SEG10COM3    0x04
#define _LCDDATA10_S10C3        0x04
#define _LCDDATA10_SEG11        0x08
#define _LCDDATA10_SEG11COM3    0x08
#define _LCDDATA10_S11C3        0x08
#define _LCDDATA10_SEG12        0x10
#define _LCDDATA10_SEG12COM3    0x10
#define _LCDDATA10_S12C3        0x10
#define _LCDDATA10_SEG13        0x20
#define _LCDDATA10_SEG13COM3    0x20
#define _LCDDATA10_S13C3        0x20
#define _LCDDATA10_SEG14        0x40
#define _LCDDATA10_SEG14COM3    0x40
#define _LCDDATA10_S14C3        0x40
#define _LCDDATA10_SEG15        0x80
#define _LCDDATA10_SEG15COM3    0x80
#define _LCDDATA10_S15C3        0x80

//==============================================================================


//==============================================================================
//        LCDSE0 Bits

extern __at(0x011C) __sfr LCDSE0;

typedef union
  {
  struct
    {
    unsigned SEG0               : 1;
    unsigned SEG1               : 1;
    unsigned SEG2               : 1;
    unsigned SEG3               : 1;
    unsigned SEG4               : 1;
    unsigned SEG5               : 1;
    unsigned SEG6               : 1;
    unsigned SEG7               : 1;
    };

  struct
    {
    unsigned SE0                : 1;
    unsigned SE1                : 1;
    unsigned SE2                : 1;
    unsigned SE3                : 1;
    unsigned SE4                : 1;
    unsigned SE5                : 1;
    unsigned SE6                : 1;
    unsigned SE7                : 1;
    };

  struct
    {
    unsigned SEGEN0             : 1;
    unsigned SEGEN1             : 1;
    unsigned SEGEN2             : 1;
    unsigned SEGEN3             : 1;
    unsigned SEGEN4             : 1;
    unsigned SEGEN5             : 1;
    unsigned SEGEN6             : 1;
    unsigned SEGEN7             : 1;
    };
  } __LCDSE0bits_t;

extern __at(0x011C) volatile __LCDSE0bits_t LCDSE0bits;

#define _LCDSE0_SEG0            0x01
#define _LCDSE0_SE0             0x01
#define _LCDSE0_SEGEN0          0x01
#define _LCDSE0_SEG1            0x02
#define _LCDSE0_SE1             0x02
#define _LCDSE0_SEGEN1          0x02
#define _LCDSE0_SEG2            0x04
#define _LCDSE0_SE2             0x04
#define _LCDSE0_SEGEN2          0x04
#define _LCDSE0_SEG3            0x08
#define _LCDSE0_SE3             0x08
#define _LCDSE0_SEGEN3          0x08
#define _LCDSE0_SEG4            0x10
#define _LCDSE0_SE4             0x10
#define _LCDSE0_SEGEN4          0x10
#define _LCDSE0_SEG5            0x20
#define _LCDSE0_SE5             0x20
#define _LCDSE0_SEGEN5          0x20
#define _LCDSE0_SEG6            0x40
#define _LCDSE0_SE6             0x40
#define _LCDSE0_SEGEN6          0x40
#define _LCDSE0_SEG7            0x80
#define _LCDSE0_SE7             0x80
#define _LCDSE0_SEGEN7          0x80

//==============================================================================


//==============================================================================
//        LCDSE1 Bits

extern __at(0x011D) __sfr LCDSE1;

typedef union
  {
  struct
    {
    unsigned SEG8               : 1;
    unsigned SEG9               : 1;
    unsigned SEG10              : 1;
    unsigned SEG11              : 1;
    unsigned SEG12              : 1;
    unsigned SEG13              : 1;
    unsigned SEG14              : 1;
    unsigned SEG15              : 1;
    };

  struct
    {
    unsigned SE8                : 1;
    unsigned SE9                : 1;
    unsigned SE10               : 1;
    unsigned SE11               : 1;
    unsigned SE12               : 1;
    unsigned SE13               : 1;
    unsigned SE14               : 1;
    unsigned SE15               : 1;
    };

  struct
    {
    unsigned SEGEN8             : 1;
    unsigned SEGEN9             : 1;
    unsigned SEGEN10            : 1;
    unsigned SEGEN11            : 1;
    unsigned SEGEN12            : 1;
    unsigned SEGEN13            : 1;
    unsigned SEGEN14            : 1;
    unsigned SEGEN15            : 1;
    };
  } __LCDSE1bits_t;

extern __at(0x011D) volatile __LCDSE1bits_t LCDSE1bits;

#define _LCDSE1_SEG8            0x01
#define _LCDSE1_SE8             0x01
#define _LCDSE1_SEGEN8          0x01
#define _LCDSE1_SEG9            0x02
#define _LCDSE1_SE9             0x02
#define _LCDSE1_SEGEN9          0x02
#define _LCDSE1_SEG10           0x04
#define _LCDSE1_SE10            0x04
#define _LCDSE1_SEGEN10         0x04
#define _LCDSE1_SEG11           0x08
#define _LCDSE1_SE11            0x08
#define _LCDSE1_SEGEN11         0x08
#define _LCDSE1_SEG12           0x10
#define _LCDSE1_SE12            0x10
#define _LCDSE1_SEGEN12         0x10
#define _LCDSE1_SEG13           0x20
#define _LCDSE1_SE13            0x20
#define _LCDSE1_SEGEN13         0x20
#define _LCDSE1_SEG14           0x40
#define _LCDSE1_SE14            0x40
#define _LCDSE1_SEGEN14         0x40
#define _LCDSE1_SEG15           0x80
#define _LCDSE1_SE15            0x80
#define _LCDSE1_SEGEN15         0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x018C) __sfr EECON1;

typedef union
  {
  struct
    {
    unsigned RD                 : 1;
    unsigned WR                 : 1;
    unsigned WREN               : 1;
    unsigned WRERR              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned EEPGD              : 1;
    };

  struct
    {
    unsigned EERD               : 1;
    unsigned EEWR               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __EECON1bits_t;

extern __at(0x018C) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _EERD                   0x01
#define _WR                     0x02
#define _EEWR                   0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x018D) __sfr EECON2;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG                 0x2007

//----------------------------- CONFIG Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP oscillator: Low-power crystal on RA6/OSC2/CLKOUT/T1OSO and RA7/OSC1/CLKIN/T1OSI.
#define _LP_OSC                 0x3FF8  // LP oscillator: Low-power crystal on RA6/OSC2/CLKOUT/T1OSO and RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_XT                0x3FF9  // XT oscillator: Crystal/resonator on RA6/OSC2/CLKOUT/T1OSO and RA7/OSC1/CLKIN/T1OSI.
#define _XT_OSC                 0x3FF9  // XT oscillator: Crystal/resonator on RA6/OSC2/CLKOUT/T1OSO and RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_HS                0x3FFA  // HS oscillator: High-speed crystal/resonator on RA6/OSC2/CLKOUT/T1OSO and RA7/OSC1/CLKIN/T1OSI.
#define _HS_OSC                 0x3FFA  // HS oscillator: High-speed crystal/resonator on RA6/OSC2/CLKOUT/T1OSO and RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_EC                0x3FFB  // EC: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, CLKIN on RA7/OSC1/CLKIN/T1OSI.
#define _EC_OSC                 0x3FFB  // EC: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, CLKIN on RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_INTOSCIO          0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, I/O function on RA7/OSC1/CLKIN/T1OSI.
#define _INTRC_OSC_NOCLKOUT     0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, I/O function on RA7/OSC1/CLKIN/T1OSI.
#define _INTOSCIO               0x3FFC  // INTOSCIO oscillator: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, I/O function on RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_INTOSCCLK         0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT/T1OSO pin, I/O function on RA7/OSC1/CLKIN/T1OSI.
#define _INTRC_OSC_CLKOUT       0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT/T1OSO pin, I/O function on RA7/OSC1/CLKIN/T1OSI.
#define _INTOSC                 0x3FFD  // INTOSC oscillator: CLKOUT function on RA6/OSC2/CLKOUT/T1OSO pin, I/O function on RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_EXTRCIO           0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, RC on RA7/OSC1/CLKIN/T1OSI.
#define _EXTRC_OSC_NOCLKOUT     0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, RC on RA7/OSC1/CLKIN/T1OSI.
#define _EXTRCIO                0x3FFE  // RCIO oscillator: I/O function on RA6/OSC2/CLKOUT/T1OSO pin, RC on RA7/OSC1/CLKIN/T1OSI.
#define _FOSC_EXTRCCLK          0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT/T1OSO pin, RC on RA7/OSC1/CLKIN/T1OSI.
#define _EXTRC_OSC_CLKOUT       0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT/T1OSO pin, RC on RA7/OSC1/CLKIN/T1OSI.
#define _EXTRC                  0x3FFF  // RC oscillator: CLKOUT function on RA6/OSC2/CLKOUT/T1OSO pin, RC on RA7/OSC1/CLKIN/T1OSI.
#define _WDTE_OFF               0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDT_OFF                0x3FF7  // WDT disabled and can be enabled by SWDTEN bit of the WDTCON register.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _WDT_ON                 0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FEF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FDF  // RE3/MCLR pin function is digital input, MCLR internally tied to VDD.
#define _MCLRE_ON               0x3FFF  // RE3/MCLR pin function is MCLR.
#define _CP_ON                  0x3FBF  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _CPD_ON                 0x3F7F  // Data memory code protection is enabled.
#define _CPD_OFF                0x3FFF  // Data memory code protection is disabled.
#define _BOREN_OFF              0x3CFF  // BOR disabled.
#define _BOD_OFF                0x3CFF  // BOR disabled.
#define _BOREN_SBODEN           0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOD_SBODEN             0x3DFF  // BOR controlled by SBOREN bit of the PCON register.
#define _BOREN_NSLEEP           0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOD_NSLEEP             0x3EFF  // BOR enabled during operation and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // BOR enabled.
#define _BOD_ON                 0x3FFF  // BOR enabled.
#define _IESO_OFF               0x3BFF  // Internal/External Switchover mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover mode is enabled.
#define _FCMEN_OFF              0x37FF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, RB6/ICSPCLK and RB7/ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, RB6/ISCPCLK and RB7/ICSPDAT are general purpose I/O pins.

//==============================================================================

#define _DEVID1                 0x2006

#define _IDLOC0                 0x2000
#define _IDLOC1                 0x2001
#define _IDLOC2                 0x2002
#define _IDLOC3                 0x2003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 1, shadows bit in ADCON0bits
#define GO_DONE                 ADCON0bits.GO_DONE              // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define VCFG0                   ADCON0bits.VCFG0                // bit 5
#define VCFG1                   ADCON0bits.VCFG1                // bit 6
#define ADFM                    ADCON0bits.ADFM                 // bit 7

#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6

#define ANS0                    ANSELbits.ANS0                  // bit 0, shadows bit in ANSELbits
#define AN0                     ANSELbits.AN0                   // bit 0, shadows bit in ANSELbits
#define ANS1                    ANSELbits.ANS1                  // bit 1, shadows bit in ANSELbits
#define AN1                     ANSELbits.AN1                   // bit 1, shadows bit in ANSELbits
#define ANS2                    ANSELbits.ANS2                  // bit 2, shadows bit in ANSELbits
#define AN2                     ANSELbits.AN2                   // bit 2, shadows bit in ANSELbits
#define ANS3                    ANSELbits.ANS3                  // bit 3, shadows bit in ANSELbits
#define AN3                     ANSELbits.AN3                   // bit 3, shadows bit in ANSELbits
#define ANS4                    ANSELbits.ANS4                  // bit 4, shadows bit in ANSELbits
#define AN4                     ANSELbits.AN4                   // bit 4, shadows bit in ANSELbits

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define CCP1Y                   CCP1CONbits.CCP1Y               // bit 4
#define CCP1X                   CCP1CONbits.CCP1X               // bit 5

#define CM0                     CMCON0bits.CM0                  // bit 0
#define CM1                     CMCON0bits.CM1                  // bit 1
#define CM2                     CMCON0bits.CM2                  // bit 2
#define CIS                     CMCON0bits.CIS                  // bit 3
#define C1INV                   CMCON0bits.C1INV                // bit 4
#define C2INV                   CMCON0bits.C2INV                // bit 5
#define C1OUT                   CMCON0bits.C1OUT                // bit 6
#define C2OUT                   CMCON0bits.C2OUT                // bit 7

#define C2SYNC                  CMCON1bits.C2SYNC               // bit 0
#define T1GSS                   CMCON1bits.T1GSS                // bit 1

#define EEADRL0                 EEADRbits.EEADRL0               // bit 0
#define EEADRL1                 EEADRbits.EEADRL1               // bit 1
#define EEADRL2                 EEADRbits.EEADRL2               // bit 2
#define EEADRL3                 EEADRbits.EEADRL3               // bit 3
#define EEADRL4                 EEADRbits.EEADRL4               // bit 4
#define EEADRL5                 EEADRbits.EEADRL5               // bit 5
#define EEADRL6                 EEADRbits.EEADRL6               // bit 6
#define EEADRL7                 EEADRbits.EEADRL7               // bit 7

#define EEADRH0                 EEADRHbits.EEADRH0              // bit 0
#define EEADRH1                 EEADRHbits.EEADRH1              // bit 1
#define EEADRH2                 EEADRHbits.EEADRH2              // bit 2
#define EEADRH3                 EEADRHbits.EEADRH3              // bit 3
#define EEADRH4                 EEADRHbits.EEADRH4              // bit 4

#define RD                      EECON1bits.RD                   // bit 0, shadows bit in EECON1bits
#define EERD                    EECON1bits.EERD                 // bit 0, shadows bit in EECON1bits
#define WR                      EECON1bits.WR                   // bit 1, shadows bit in EECON1bits
#define EEWR                    EECON1bits.EEWR                 // bit 1, shadows bit in EECON1bits
#define WREN                    EECON1bits.WREN                 // bit 2
#define WRERR                   EECON1bits.WRERR                // bit 3
#define EEPGD                   EECON1bits.EEPGD                // bit 7

#define EEDATL0                 EEDATAbits.EEDATL0              // bit 0
#define EEDATL1                 EEDATAbits.EEDATL1              // bit 1
#define EEDATL2                 EEDATAbits.EEDATL2              // bit 2
#define EEDATL3                 EEDATAbits.EEDATL3              // bit 3
#define EEDATL4                 EEDATAbits.EEDATL4              // bit 4
#define EEDATL5                 EEDATAbits.EEDATL5              // bit 5
#define EEDATL6                 EEDATAbits.EEDATL6              // bit 6
#define EEDATL7                 EEDATAbits.EEDATL7              // bit 7

#define EEDATH0                 EEDATHbits.EEDATH0              // bit 0
#define EEDATH1                 EEDATHbits.EEDATH1              // bit 1
#define EEDATH2                 EEDATHbits.EEDATH2              // bit 2
#define EEDATH3                 EEDATHbits.EEDATH3              // bit 3
#define EEDATH4                 EEDATHbits.EEDATH4              // bit 4
#define EEDATH5                 EEDATHbits.EEDATH5              // bit 5

#define RBIF                    INTCONbits.RBIF                 // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define RBIE                    INTCONbits.RBIE                 // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCB4                   IOCbits.IOCB4                   // bit 4, shadows bit in IOCbits
#define IOC4                    IOCbits.IOC4                    // bit 4, shadows bit in IOCbits
#define IOCB5                   IOCbits.IOCB5                   // bit 5, shadows bit in IOCbits
#define IOC5                    IOCbits.IOC5                    // bit 5, shadows bit in IOCbits
#define IOCB6                   IOCbits.IOCB6                   // bit 6, shadows bit in IOCbits
#define IOC6                    IOCbits.IOC6                    // bit 6, shadows bit in IOCbits
#define IOCB7                   IOCbits.IOCB7                   // bit 7, shadows bit in IOCbits
#define IOC7                    IOCbits.IOC7                    // bit 7, shadows bit in IOCbits

#define LMUX0                   LCDCONbits.LMUX0                // bit 0
#define LMUX1                   LCDCONbits.LMUX1                // bit 1
#define CS0                     LCDCONbits.CS0                  // bit 2
#define CS1                     LCDCONbits.CS1                  // bit 3
#define VLCDEN                  LCDCONbits.VLCDEN               // bit 4
#define WERR                    LCDCONbits.WERR                 // bit 5
#define SLPEN                   LCDCONbits.SLPEN                // bit 6
#define LCDEN                   LCDCONbits.LCDEN                // bit 7

#define SEG0                    LCDDATA0bits.SEG0               // bit 0, shadows bit in LCDDATA0bits
#define SEG0COM0                LCDDATA0bits.SEG0COM0           // bit 0, shadows bit in LCDDATA0bits
#define S0C0                    LCDDATA0bits.S0C0               // bit 0, shadows bit in LCDDATA0bits
#define SEG1                    LCDDATA0bits.SEG1               // bit 1, shadows bit in LCDDATA0bits
#define SEG1COM0                LCDDATA0bits.SEG1COM0           // bit 1, shadows bit in LCDDATA0bits
#define S1C0                    LCDDATA0bits.S1C0               // bit 1, shadows bit in LCDDATA0bits
#define SEG2                    LCDDATA0bits.SEG2               // bit 2, shadows bit in LCDDATA0bits
#define SEG2COM0                LCDDATA0bits.SEG2COM0           // bit 2, shadows bit in LCDDATA0bits
#define S2C0                    LCDDATA0bits.S2C0               // bit 2, shadows bit in LCDDATA0bits
#define SEG3                    LCDDATA0bits.SEG3               // bit 3, shadows bit in LCDDATA0bits
#define SEG3COM0                LCDDATA0bits.SEG3COM0           // bit 3, shadows bit in LCDDATA0bits
#define S3C0                    LCDDATA0bits.S3C0               // bit 3, shadows bit in LCDDATA0bits
#define SEG4                    LCDDATA0bits.SEG4               // bit 4, shadows bit in LCDDATA0bits
#define SEG4COM0                LCDDATA0bits.SEG4COM0           // bit 4, shadows bit in LCDDATA0bits
#define S4C0                    LCDDATA0bits.S4C0               // bit 4, shadows bit in LCDDATA0bits
#define SEG5                    LCDDATA0bits.SEG5               // bit 5, shadows bit in LCDDATA0bits
#define SEG5COM0                LCDDATA0bits.SEG5COM0           // bit 5, shadows bit in LCDDATA0bits
#define S5C0                    LCDDATA0bits.S5C0               // bit 5, shadows bit in LCDDATA0bits
#define SEG6                    LCDDATA0bits.SEG6               // bit 6, shadows bit in LCDDATA0bits
#define SEG6COM0                LCDDATA0bits.SEG6COM0           // bit 6, shadows bit in LCDDATA0bits
#define S6C0                    LCDDATA0bits.S6C0               // bit 6, shadows bit in LCDDATA0bits
#define SEG7                    LCDDATA0bits.SEG7               // bit 7, shadows bit in LCDDATA0bits
#define SEG7COM0                LCDDATA0bits.SEG7COM0           // bit 7, shadows bit in LCDDATA0bits
#define S7C0                    LCDDATA0bits.S7C0               // bit 7, shadows bit in LCDDATA0bits

#define SEG8                    LCDDATA1bits.SEG8               // bit 0, shadows bit in LCDDATA1bits
#define SEG8COM0                LCDDATA1bits.SEG8COM0           // bit 0, shadows bit in LCDDATA1bits
#define S8C0                    LCDDATA1bits.S8C0               // bit 0, shadows bit in LCDDATA1bits
#define SEG9                    LCDDATA1bits.SEG9               // bit 1, shadows bit in LCDDATA1bits
#define SEG9COM0                LCDDATA1bits.SEG9COM0           // bit 1, shadows bit in LCDDATA1bits
#define S9C0                    LCDDATA1bits.S9C0               // bit 1, shadows bit in LCDDATA1bits
#define SEG10                   LCDDATA1bits.SEG10              // bit 2, shadows bit in LCDDATA1bits
#define SEG10COM0               LCDDATA1bits.SEG10COM0          // bit 2, shadows bit in LCDDATA1bits
#define S10C0                   LCDDATA1bits.S10C0              // bit 2, shadows bit in LCDDATA1bits
#define SEG11                   LCDDATA1bits.SEG11              // bit 3, shadows bit in LCDDATA1bits
#define SEG11COM0               LCDDATA1bits.SEG11COM0          // bit 3, shadows bit in LCDDATA1bits
#define S11C0                   LCDDATA1bits.S11C0              // bit 3, shadows bit in LCDDATA1bits
#define SEG12                   LCDDATA1bits.SEG12              // bit 4, shadows bit in LCDDATA1bits
#define SEG12COM0               LCDDATA1bits.SEG12COM0          // bit 4, shadows bit in LCDDATA1bits
#define S12C0                   LCDDATA1bits.S12C0              // bit 4, shadows bit in LCDDATA1bits
#define SEG13                   LCDDATA1bits.SEG13              // bit 5, shadows bit in LCDDATA1bits
#define SEG13COM0               LCDDATA1bits.SEG13COM0          // bit 5, shadows bit in LCDDATA1bits
#define S13C0                   LCDDATA1bits.S13C0              // bit 5, shadows bit in LCDDATA1bits
#define SEG14                   LCDDATA1bits.SEG14              // bit 6, shadows bit in LCDDATA1bits
#define SEG14COM0               LCDDATA1bits.SEG14COM0          // bit 6, shadows bit in LCDDATA1bits
#define S14C0                   LCDDATA1bits.S14C0              // bit 6, shadows bit in LCDDATA1bits
#define SEG15                   LCDDATA1bits.SEG15              // bit 7, shadows bit in LCDDATA1bits
#define SEG15COM0               LCDDATA1bits.SEG15COM0          // bit 7, shadows bit in LCDDATA1bits
#define S15C0                   LCDDATA1bits.S15C0              // bit 7, shadows bit in LCDDATA1bits

#define LP0                     LCDPSbits.LP0                   // bit 0
#define LP1                     LCDPSbits.LP1                   // bit 1
#define LP2                     LCDPSbits.LP2                   // bit 2
#define LP3                     LCDPSbits.LP3                   // bit 3
#define WA                      LCDPSbits.WA                    // bit 4
#define LCDA                    LCDPSbits.LCDA                  // bit 5
#define BIASMD                  LCDPSbits.BIASMD                // bit 6
#define WFT                     LCDPSbits.WFT                   // bit 7

#define LVDL0                   LVDCONbits.LVDL0                // bit 0
#define LVDL1                   LVDCONbits.LVDL1                // bit 1
#define LVDL2                   LVDCONbits.LVDL2                // bit 2
#define LVDEN                   LVDCONbits.LVDEN                // bit 4
#define IRVST                   LVDCONbits.IRVST                // bit 5

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define T0SE                    OPTION_REGbits.T0SE             // bit 4
#define T0CS                    OPTION_REGbits.T0CS             // bit 5
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_RBPU                OPTION_REGbits.NOT_RBPU         // bit 7

#define SCS                     OSCCONbits.SCS                  // bit 0
#define LTS                     OSCCONbits.LTS                  // bit 1
#define HTS                     OSCCONbits.HTS                  // bit 2
#define OSTS                    OSCCONbits.OSTS                 // bit 3
#define IRCF0                   OSCCONbits.IRCF0                // bit 4
#define IRCF1                   OSCCONbits.IRCF1                // bit 5
#define IRCF2                   OSCCONbits.IRCF2                // bit 6

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0, shadows bit in PCONbits
#define NOT_BO                  PCONbits.NOT_BO                 // bit 0, shadows bit in PCONbits
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define SBOREN                  PCONbits.SBOREN                 // bit 4

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSPIE                   PIE1bits.SSPIE                  // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define EEIE                    PIE1bits.EEIE                   // bit 7

#define LVDIE                   PIE2bits.LVDIE                  // bit 2
#define LCDIE                   PIE2bits.LCDIE                  // bit 4
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSPIF                   PIR1bits.SSPIF                  // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define EEIF                    PIR1bits.EEIF                   // bit 7

#define LVDIF                   PIR2bits.LVDIF                  // bit 2
#define LCDIF                   PIR2bits.LCDIF                  // bit 4
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RE3                     PORTEbits.RE3                   // bit 3

#define RX9D                    RCSTAbits.RX9D                  // bit 0, shadows bit in RCSTAbits
#define RCD8                    RCSTAbits.RCD8                  // bit 0, shadows bit in RCSTAbits
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6, shadows bit in RCSTAbits
#define RC9                     RCSTAbits.RC9                   // bit 6, shadows bit in RCSTAbits
#define NOT_RC8                 RCSTAbits.NOT_RC8               // bit 6, shadows bit in RCSTAbits
#define RC8_9                   RCSTAbits.RC8_9                 // bit 6, shadows bit in RCSTAbits
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define SSPM0                   SSPCONbits.SSPM0                // bit 0
#define SSPM1                   SSPCONbits.SSPM1                // bit 1
#define SSPM2                   SSPCONbits.SSPM2                // bit 2
#define SSPM3                   SSPCONbits.SSPM3                // bit 3
#define CKP                     SSPCONbits.CKP                  // bit 4
#define SSPEN                   SSPCONbits.SSPEN                // bit 5
#define SSPOV                   SSPCONbits.SSPOV                // bit 6
#define WCOL                    SSPCONbits.WCOL                 // bit 7

#define BF                      SSPSTATbits.BF                  // bit 0
#define UA                      SSPSTATbits.UA                  // bit 1
#define R_NOT_W                 SSPSTATbits.R_NOT_W             // bit 2, shadows bit in SSPSTATbits
#define R                       SSPSTATbits.R                   // bit 2, shadows bit in SSPSTATbits
#define I2C_READ                SSPSTATbits.I2C_READ            // bit 2, shadows bit in SSPSTATbits
#define NOT_W                   SSPSTATbits.NOT_W               // bit 2, shadows bit in SSPSTATbits
#define NOT_WRITE               SSPSTATbits.NOT_WRITE           // bit 2, shadows bit in SSPSTATbits
#define R_W                     SSPSTATbits.R_W                 // bit 2, shadows bit in SSPSTATbits
#define READ_WRITE              SSPSTATbits.READ_WRITE          // bit 2, shadows bit in SSPSTATbits
#define S                       SSPSTATbits.S                   // bit 3, shadows bit in SSPSTATbits
#define I2C_START               SSPSTATbits.I2C_START           // bit 3, shadows bit in SSPSTATbits
#define P                       SSPSTATbits.P                   // bit 4, shadows bit in SSPSTATbits
#define I2C_STOP                SSPSTATbits.I2C_STOP            // bit 4, shadows bit in SSPSTATbits
#define D_NOT_A                 SSPSTATbits.D_NOT_A             // bit 5, shadows bit in SSPSTATbits
#define D                       SSPSTATbits.D                   // bit 5, shadows bit in SSPSTATbits
#define I2C_DATA                SSPSTATbits.I2C_DATA            // bit 5, shadows bit in SSPSTATbits
#define NOT_A                   SSPSTATbits.NOT_A               // bit 5, shadows bit in SSPSTATbits
#define NOT_ADDRESS             SSPSTATbits.NOT_ADDRESS         // bit 5, shadows bit in SSPSTATbits
#define D_A                     SSPSTATbits.D_A                 // bit 5, shadows bit in SSPSTATbits
#define DATA_ADDRESS            SSPSTATbits.DATA_ADDRESS        // bit 5, shadows bit in SSPSTATbits
#define CKE                     SSPSTATbits.CKE                 // bit 6
#define SMP                     SSPSTATbits.SMP                 // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4
#define RP0                     STATUSbits.RP0                  // bit 5
#define RP1                     STATUSbits.RP1                  // bit 6
#define IRP                     STATUSbits.IRP                  // bit 7

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define TMR1CS                  T1CONbits.TMR1CS                // bit 1
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2, shadows bit in T1CONbits
#define T1SYNC                  T1CONbits.T1SYNC                // bit 2, shadows bit in T1CONbits
#define T1INSYNC                T1CONbits.T1INSYNC              // bit 2, shadows bit in T1CONbits
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1GE                  T1CONbits.TMR1GE                // bit 6, shadows bit in T1CONbits
#define T1GE                    T1CONbits.T1GE                  // bit 6, shadows bit in T1CONbits
#define T1GINV                  T1CONbits.T1GINV                // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define TOUTPS0                 T2CONbits.TOUTPS0               // bit 3
#define TOUTPS1                 T2CONbits.TOUTPS1               // bit 4
#define TOUTPS2                 T2CONbits.TOUTPS2               // bit 5
#define TOUTPS3                 T2CONbits.TOUTPS3               // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define TX9D                    TXSTAbits.TX9D                  // bit 0, shadows bit in TXSTAbits
#define TXD8                    TXSTAbits.TXD8                  // bit 0, shadows bit in TXSTAbits
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6, shadows bit in TXSTAbits
#define NOT_TX8                 TXSTAbits.NOT_TX8               // bit 6, shadows bit in TXSTAbits
#define TX8_9                   TXSTAbits.TX8_9                 // bit 6, shadows bit in TXSTAbits
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define VR0                     VRCONbits.VR0                   // bit 0
#define VR1                     VRCONbits.VR1                   // bit 1
#define VR2                     VRCONbits.VR2                   // bit 2
#define VR3                     VRCONbits.VR3                   // bit 3
#define VRR                     VRCONbits.VRR                   // bit 5
#define VREN                    VRCONbits.VREN                  // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0, shadows bit in WDTCONbits
#define SWDTE                   WDTCONbits.SWDTE                // bit 0, shadows bit in WDTCONbits
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4

#define WPUB0                   WPUbits.WPUB0                   // bit 0, shadows bit in WPUbits
#define WPU0                    WPUbits.WPU0                    // bit 0, shadows bit in WPUbits
#define WPUB1                   WPUbits.WPUB1                   // bit 1, shadows bit in WPUbits
#define WPU1                    WPUbits.WPU1                    // bit 1, shadows bit in WPUbits
#define WPUB2                   WPUbits.WPUB2                   // bit 2, shadows bit in WPUbits
#define WPU2                    WPUbits.WPU2                    // bit 2, shadows bit in WPUbits
#define WPUB3                   WPUbits.WPUB3                   // bit 3, shadows bit in WPUbits
#define WPU3                    WPUbits.WPU3                    // bit 3, shadows bit in WPUbits
#define WPUB4                   WPUbits.WPUB4                   // bit 4, shadows bit in WPUbits
#define WPU4                    WPUbits.WPU4                    // bit 4, shadows bit in WPUbits
#define WPUB5                   WPUbits.WPUB5                   // bit 5, shadows bit in WPUbits
#define WPU5                    WPUbits.WPU5                    // bit 5, shadows bit in WPUbits
#define WPUB6                   WPUbits.WPUB6                   // bit 6, shadows bit in WPUbits
#define WPU6                    WPUbits.WPU6                    // bit 6, shadows bit in WPUbits
#define WPUB7                   WPUbits.WPUB7                   // bit 7, shadows bit in WPUbits
#define WPU7                    WPUbits.WPU7                    // bit 7, shadows bit in WPUbits

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F916_H__
